<?php 
 
include '../../../conexion/conexion.php';

$datos = array();
$type = addslashes($_REQUEST["type"]);
$fecha_actual = new DateTime();
switch ($type) {
	case 'all':
		$buscar = "SELECT * FROM trainings ";
		$ex = mysqli_query($conexion,$buscar);
		if(mysqli_num_rows($ex)>0){
			$datos["info"]["baja"] = [];
			$datos["info"]["pendiente"] = [];
			$datos["info"]["activo"] = [];
			$datos["info"]["caduco"] = [];

			while($rows = mysqli_fetch_array($ex)){
				$admons = [];
				$pending = 0;
				$started = 0;
				$ended = 0;

				if($rows["type"]=="0"){
					$sads = mysqli_query($conexion,"SELECT  adt.id_admon_training, adt.id_training, adt.id_admon, CONCAT(adm.nombre,' ',adm.apellidos) AS admon FROM admons_training adt INNER JOIN admons adm ON adm.id_admon = adt.id_admon  WHERE adt.status=1 AND adt.id_training=".$rows["id_training"]);
					$total = mysqli_num_rows($sads);
					while($ad = mysqli_fetch_array($sads)){
						$ad["status_training"]=status_training($ad["id_admon"],$ad["id_training"],$conexion);
						$admons[] = $ad;
						$pending += ($ad["status_training"]["status"] == "0") ? 1 : 0;
						$started += ($ad["status_training"]["status"] == "1") ? 1 : 0;
						$ended += ($ad["status_training"]["status"] == "2") ? 1 : 0;
					}
				}else{
					$sads = mysqli_query($conexion,"SELECT id_admon, CONCAT(nombre,' ',apellidos) AS admon FROM admons WHERE status=1");
					$total = mysqli_num_rows($sads);
					while($ad = mysqli_fetch_array($sads)){
						$ad["status_training"]=status_training($ad["id_admon"],$rows["id_training"],$conexion);
						$admons[] = $ad;
						$pending += ($ad["status_training"]["status"] == "0") ? 1 : 0;
						$started += ($ad["status_training"]["status"] == "1") ? 1 : 0;
						$ended += ($ad["status_training"]["status"] == "2") ? 1 : 0;
					}
				}

				

				$rows["progress"]["pending"]["qt"] = $pending;
				$rows["progress"]["pending"]["average"] = number_format((($pending*100)/$total),1,'.','');

				$rows["progress"]["started"]["qt"] = $started;
				$rows["progress"]["started"]["average"] = number_format((($started*100)/$total),1,'.','');

				$rows["progress"]["ended"]["qt"] = $ended;
				$rows["progress"]["ended"]["average"] = number_format((($ended*100)/$total),1,'.','');

				$rows["progress"]["total"] = $total;
				$rows["type_desc"] = ($rows["type"]=="1")?'Abierto':'Privado'; 
				$rows["admons"] = $admons;

				$fecha_vigencia =  new DateTime($rows["date_end"]);
				$fecha_vigencia->modify('+1 day');

				$fecha_inicio =  new DateTime($rows["date_ini"]);
				
				if($rows["status"]=="0"){
					$datos["info"]["baja"][]=$rows;
				}else if($rows["status"]=="1"&&($fecha_inicio > $fecha_actual)){
					$datos["info"]["pendiente"][]=$rows;
				}else if($rows["status"]=="1"&&($fecha_actual <= $fecha_vigencia)){
					$datos["info"]["activo"][]=$rows;
				}else{
					$datos["info"]["caduco"][]=$rows;
				}
			}

			$datos["val"]=true;	
			$datos["mensaje"]="";
		}else{
			$datos["val"]=false;
			$datos["info"]="";
			$datos["mensaje"]="No se encontraron capacitaciones.";
		}
		break;

	case 'by_admon':
		$id_admon_to_aply = addslashes($_REQUEST['id_admon_to_aply']);
		$fecha = $fecha_actual->format('Y-m-d');
		$buscar = "SELECT * FROM trainings WHERE '".$fecha."' BETWEEN date_ini AND date_end AND status = 1";
		
		$ex = mysqli_query($conexion,$buscar);
		if(mysqli_num_rows($ex)>0){
			$datos["info"]["baja"] = [];
			$datos["info"]["pendiente"] = [];
			$datos["info"]["activo"] = [];
			$datos["info"]["caduco"] = [];

			while($rows = mysqli_fetch_array($ex)){
				$admons = [];
				$pending = 0;
				$started = 0;
				$ended = 0;
				$qt = 0;

				if($rows["type"]=="0"){
					$query ="SELECT adt.id_admon_training, adt.id_training, CONCAT(adm.nombre,' ',adm.apellidos) AS admon FROM admons_training adt INNER JOIN admons adm ON adm.id_admon = adt.id_admon WHERE adt.status=1 AND adt.id_training=".$rows["id_training"]." AND adt.id_admon=".$id_admon_to_aply;
					$sads = mysqli_query($conexion,$query);
					$qt = mysqli_num_rows($sads);
					while($ad = mysqli_fetch_array($sads)){
						$ad["status_training"]=status_training($id_admon_to_aply,$ad["id_training"],$conexion);
						$admons[] = $ad;
					}
				}else{
					$sads = mysqli_query($conexion,"SELECT id_admon, CONCAT(nombre,' ',apellidos) AS admon FROM admons WHERE status=1 AND id_admon=".$id_admon_to_aply);
					$qt = mysqli_num_rows($sads);

					while($ad = mysqli_fetch_array($sads)){
						$ad["status_training"]=status_training($ad["id_admon"],$rows["id_training"],$conexion);
						$admons[] = $ad;
					}
				}

			
				$rows["type_desc"] = ($rows["type"]=="1")?'Abierto':'Privado'; 
				$rows["admons"] = $admons;

				$fecha_vigencia =  new DateTime($rows["date_end"]);
				$fecha_inicio =  new DateTime($rows["date_ini"]);
				
				if($rows["status"]=="0"){
					$datos["info"]["baja"][]=$rows;
				}else if($rows["status"]=="1"&&($fecha_inicio > $fecha_actual)){
					$datos["info"]["pendiente"][]=$rows;
				}else if($rows["status"]=="1"&&($fecha_actual <= $fecha_vigencia)){
					if($qt>0)
						$datos["info"]["activo"][]=$rows;
				}else{
					$datos["info"]["caduco"][]=$rows;
				}


			}

			$datos["val"]=true;	
			$datos["mensaje"]="";
		}else{
			$datos["val"]=false;
			$datos["info"]="";
			$datos["mensaje"]="No se encontraron registros.";
		}
	


}

function status_training($id_admon,$id_training, $conexion){
	$query = "SELECT * FROM training_status_by_admon WHERE status<>0 AND id_admon=$id_admon AND id_training=$id_training";
	$q = mysqli_query($conexion, $query);
	if(mysqli_num_rows($q)>0){
		$data = mysqli_fetch_array($q);
		$ret["status"] = $data["status"];
		$ret["date_start"] = $data["date_start"];
		$ret["date_end"] = $data["date_end"];
		$ret["date_time"] = $data["date_time"];
		$ret["last_update"] = $data["last_update"];
		$ret["id"] = $data["id_training_status_by_admon"];
		return ($ret);
	}else{
		$ret["status"] = 0;
		$ret["date_start"] = "";
		$ret["date_end"] = "";
		$ret["date_time"] = "";
		$ret["last_update"] = "";
		$ret["id"] = 0;
		return $ret;
	}
		
	 
}

echo json_encode($datos);
mysqli_close($conexion);
?>