<?php
include '../../../conexion/conexion.php';
$datos = array();
$type = $_REQUEST['type'];
switch ($type) {
	case 'notas_medicas':
		$buscar = "SELECT * FROM mv_notas_medicas ";	
		$ex_b = mysqli_query($conexion,$buscar);
		if(mysqli_num_rows($ex_b)>0){
			$datos = [];
			while($rows = mysqli_fetch_array($ex_b)){
				$datos["info"][]=array(
					"id"=>intval($rows["id_mv_nota_medica"]),
					"nombre"=>$rows["nombre"],
					"poliza"=>$rows["poliza"],
					"aseguradora"=>$rows["aseguradora"],
					"date_time"=>$rows["date_time"],
					"status"=>$rows["status"],
				);
			}
			$datos["val"]=true;	
		}else{
			$datos["val"]=false;
			$datos["info"]="";
			$datos["mensaje"]="No se encontraron notas medicas.";
		}
		break;

	case 'medicamentos':
		$buscar = "SELECT * FROM mv_cat_medicamentos WHERE status = 1 ORDER BY nombre_generico ASC";	
		$ex_b = mysqli_query($conexion,$buscar);
		if(mysqli_num_rows($ex_b)>0){
			$datos = [];
			while($rows = mysqli_fetch_array($ex_b)){
				$datos["info"][]=array(
					"id"=>intval($rows["id_mv_cat_medicamentos"]),
					"nombre"=>$rows["nombre_generico"].' '.$rows["presentacion"],
					"nombre_generico"=>$rows["nombre_generico"],
					"presentacion"=>$rows["presentacion"],
					"status"=>$rows["status"],
				);
			}
			$datos["val"]=true;	
		}else{
			$datos["val"]=false;
			$datos["info"]="";
			$datos["mensaje"]="No se encontraron medicamentos.";
		}

		break;

	case 'antecedentes_cronicos':
		$buscar = "SELECT * FROM mv_antecedentes_cronicos WHERE status = 1 ORDER BY nombre_antecedente ASC";	
		$ex_b = mysqli_query($conexion,$buscar);
		if(mysqli_num_rows($ex_b)>0){
			while($rows = mysqli_fetch_array($ex_b)){		
				$datos["info"][]=array(
					"id"=>intval($rows["id_mv_antecedente_cronico"]),
					"nombre"=>$rows["nombre_antecedente"],
					"status"=>$rows["status"]
				);
			}
			$datos["val"]=true;	
		}else{
			$datos["val"]=false;
			$datos["info"]="";
			$datos["mensaje"]="No se encontraron medicamentos.";
		}

		break;
}

function b($v){ return (intval($v) === 1); }
function i_($v){ return is_null($v) ? null : intval($v); }
function d_($v){ return is_null($v) ? null : floatval($v); }
function s_($v){ return is_null($v) ? "" : strval($v); }

function get_data($conexion, $id){

	try {
	  $sql = "
	    SELECT
	      nombre, fecha_nacimiento, genero, fecha_ingreso, aseguradora, poliza,
	      llega_en_amb, llega_en_pie, llega_en_particular, fecha_hora_incidente,
	      ahf, app, apnp, alergias, medicamentos_cronicos, adicciones, otros_antecedentes,
	      acc_auto, acc_motocicleta, acc_bicicleta, acc_peaton, acc_escolar, acc_otro,
	      temperatura, talla, peso, ta, fc, fr, pulso, rots, glasgow, edo_gral,
	      mec_lesion_momento, mec_lesion_posterior, descripcion_lesiones,
	      rx_craneo, rx_cervical, rx_dorsal, rx_lumbar, rx_torax, rx_oseo, rx_abdomen,
	      rx_hombro, rx_brazo, rx_antebrazo, rx_mano, rx_muslo, rx_pierna, rx_tobillo_pie,
	      rx_pelvis, rx_rodilla, rx_otro,
	      ultrasonido, rmn, tac, otros_imagen,
	      descripcion_imagen, diagnostico_principal, diagnostico_no_rel,
	      solicita_interconsulta, especialidad, curaciones, suturas, inmovilizacion, co_blando,
	      co_semirrigido, co_philadelphia, cabestrillo, faja, ferula, otro_inmovilizacion,
	      uso_por, retiro_fecha, pronostico, observaciones,
	      motivo_hosp, traslado_hosp, fecha_hora_hosp, autoriza, datos_ambulancia
	    FROM mv_notas_medicas
	    WHERE id_mv_nota_medica = ?
	    LIMIT 1";
	  $st = $conexion->prepare($sql);
	  $st->bind_param('i', $id);
	  $st->execute();
	  $row = $st->get_result()->fetch_assoc();
	  $st->close();

	  if (!$row) { echo json_encode(['ok'=>0,'error'=>'No encontrado']); exit; }

	  // prescripciones con nombre de medicamento
	  $pres = [];
	  $sp = $conexion->prepare("
	    SELECT p.id_medicamento, m.nombre_generico AS nombre_medicamento, p.cantidad, p.indicacion
	    FROM mv_notas_prescripciones p
	    JOIN mv_cat_medicamentos m ON m.id_mv_cat_medicamentos = p.id_medicamento
	    WHERE p.id_mv_nota_medica = ? AND p.status = 1
	    ORDER BY p.id_mv_nota_prescripcion ASC");
	  $sp->bind_param('i', $id);
	  $sp->execute();
	  $rp = $sp->get_result();
	  while ($p = $rp->fetch_assoc()) {
	    $pres[] = [
	      'id_medicamento' => i_($p['id_medicamento']),
	      'nombre'         => s_($p['nombre_medicamento']),
	      'cantidad'       => s_($p['cantidad']),
	      'indicacion'     => s_($p['indicacion']),
	    ];
	  }
	  $sp->close();

	  // antecedentes catalogados con nombre
	  $ants = [];
	  $sa = $conexion->prepare("
	    SELECT a.id_mv_antecedente_cronico, c.nombre_antecedente
	    FROM mv_notas_antecedentes_cat a
	    JOIN mv_antecedentes_cronicos c
	      ON c.id_mv_antecedente_cronico = a.id_mv_antecedente_cronico
	    WHERE a.id_mv_nota_medica = ? AND a.status = 1
	    ORDER BY a.id_mv_nota_ant_cat ASC");
	  $sa->bind_param('i', $id);
	  $sa->execute();
	  $ra = $sa->get_result();
	  while ($a = $ra->fetch_assoc()) {
	    $ants[] = [
	      'id_mv_antecedente_cronico' => i_($a['id_mv_antecedente_cronico']),
	      'nombre'                    => s_($a['nombre_antecedente']),
	    ];
	  }
	  $sa->close();

	  $d = [
	    "datos_paciente" => [
	      "nombre" => s_($row['nombre']),
	      "fecha_nacimiento" => s_($row['fecha_nacimiento']),
	      "genero" => s_($row['genero']),
	      "aseguradora" => s_($row['aseguradora']),
	      "poliza" => s_($row['poliza']),
	    ],
	    "datos_ingreso" => [
	      "fecha_ingreso" => s_($row['fecha_ingreso']),
	      "llega_en_amb" => i_($row['llega_en_amb']),
	      "llega_en_pie" => i_($row['llega_en_pie']),
	      "llega_en_particular" => i_($row['llega_en_particular']),
	      "fecha_hora_incidente" => s_($row['fecha_hora_incidente']),
	    ],
	    "antecedentes" => [
	      "ahf" => s_($row['ahf']),
	      "app" => s_($row['app']),
	      "apnp" => s_($row['apnp']),
	      "alergias" => s_($row['alergias']),
	      "medicamentos_cronicos" => s_($row['medicamentos_cronicos']),
	      "adicciones" => s_($row['adicciones']),
	      "otros_antecedentes" => s_($row['otros_antecedentes']),
	    ],
	    "antecedentes_catalogados" => $ants,
	    "mecanismo_lesion" => [
	      "acc_auto" => s_($row['acc_auto']),
	      "acc_motocicleta" => s_($row['acc_motocicleta']),
	      "acc_bicicleta" => s_($row['acc_bicicleta']),
	      "acc_peaton" => s_($row['acc_peaton']),
	      "acc_escolar" => s_($row['acc_escolar']),
	      "acc_otro" => s_($row['acc_otro']),
	    ],
	    "exploracion_fisica" => [
	      "temperatura" => d_($row['temperatura']),
	      "talla" => s_($row['talla']),
	      "peso" => d_($row['peso']),
	      "ta" => s_($row['ta']),
	      "fc" => i_($row['fc']),
	      "fr" => i_($row['fr']),
	      "pulso" => i_($row['pulso']),
	      "rots" => s_($row['rots']),
	      "glasgow" => s_($row['glasgow']),
	      "edo_gral" => s_($row['edo_gral']),
	      "mec_lesion_momento" => s_($row['mec_lesion_momento']),
	      "mec_lesion_posterior" => s_($row['mec_lesion_posterior']),
	      "descripcion_lesiones" => s_($row['descripcion_lesiones']),
	    ],
	    "estudios_imagen" => [
	      "rx_craneo" => b($row['rx_craneo']),
	      "rx_cervical" => b($row['rx_cervical']),
	      "rx_dorsal" => b($row['rx_dorsal']),
	      "rx_lumbar" => b($row['rx_lumbar']),
	      "rx_torax" => b($row['rx_torax']),
	      "rx_oseo" => b($row['rx_oseo']),
	      "rx_abdomen" => b($row['rx_abdomen']),
	      "rx_hombro" => b($row['rx_hombro']),
	      "rx_brazo" => b($row['rx_brazo']),
	      "rx_antebrazo" => b($row['rx_antebrazo']),
	      "rx_mano" => b($row['rx_mano']),
	      "rx_muslo" => b($row['rx_muslo']),
	      "rx_pierna" => b($row['rx_pierna']),
	      "rx_tobillo_pie" => b($row['rx_tobillo_pie']),
	      "rx_pelvis" => b($row['rx_pelvis']),
	      "rx_rodilla" => b($row['rx_rodilla']),
	      "rx_otro" => s_($row['rx_otro']),
	      "ultrasonido" => b($row['ultrasonido']),
	      "rmn" => b($row['rmn']),
	      "tac" => b($row['tac']),
	      "otros_imagen" => s_($row['otros_imagen']),
	      "descripcion_imagen" => s_($row['descripcion_imagen']),
	    ],
	    "diagnostico" => [
	      "diagnostico_principal" => s_($row['diagnostico_principal']),
	      "diagnostico_no_rel" => s_($row['diagnostico_no_rel']),
	    ],
	    "prescripcion_medicamentos" => $pres,
	    "interconsulta_procedimientos" => [
	      "solicita_interconsulta" => b($row['solicita_interconsulta']),
	      "especialidad" => s_($row['especialidad']),
	      "suturas" => i_($row['suturas']),
	      "curaciones" => i_($row['curaciones']),
	      "pronostico" => s_($row['pronostico']),
	      "observaciones" => s_($row['observaciones']),
	      "inmovilizacion" => b($row['inmovilizacion']),
	      "co_blando" => b($row['co_blando']),
	      "co_semirrigido" => b($row['co_semirrigido']),
	      "co_philadelphia" => b($row['co_philadelphia']),
	      "cabestrillo" => b($row['cabestrillo']),
	      "faja" => b($row['faja']),
	      "ferula" => b($row['ferula']),
	      "otro_inmovilizacion" => s_($row['otro_inmovilizacion']),
	      "uso_por" => s_($row['uso_por']),
	      "retiro_fecha" => is_null($row['retiro_fecha']) ? null : s_($row['retiro_fecha']),
	    ],
	    "hospitalizacion" => [
	      "motivo_hosp" => s_($row['motivo_hosp']),
	      "traslado_hosp" => s_($row['traslado_hosp']),
	      "fecha_hora" => s_($row['fecha_hora_hosp']),
	      "autoriza" => s_($row['autoriza']),
	      "datos_ambulancia" => s_($row['datos_ambulancia']),
	    ],
	  ];

	  return $d;

	} catch (Throwable $e) {
	  return [];
	} finally {
	  if (isset($conexion) && $conexion instanceof mysqli) { mysqli_close($conexion); }
	}
}

function parse_vars($d,$id_nota){
	$paciente = [];
	$paciente["id_nota_medica"] = $id_nota;
	$paciente["nombre"] = $d["datos_paciente"]["nombre"];
	$paciente["fecha_nacimiento"] = date("d/m/Y", strtotime($d["datos_paciente"]["fecha_nacimiento"]));
	$paciente["edad"] = floor((time() - strtotime($d["datos_paciente"]["fecha_nacimiento"])) / 31556926) . " años";
	$paciente["genero"] = $d["datos_paciente"]["genero"];
	$paciente["ingreso"] = date("d/m/Y h:i a", strtotime($d["datos_ingreso"]["fecha_ingreso"]));
	$paciente["aseguradora"] = $d["datos_paciente"]["aseguradora"];
	$paciente["poliza"] = $d["datos_paciente"]["poliza"];

	$paciente["llega_en_ambulancia"] = $d["datos_ingreso"]["llega_en_amb"];
	$paciente["llega_en_particular"] = $d["datos_ingreso"]["llega_en_particular"];
	$paciente["llega_en_pie"] = $d["datos_ingreso"]["llega_en_pie"];
	$paciente["fecha_hora_incidente"] = date("d/m/Y h:i a", strtotime($d["datos_ingreso"]["fecha_hora_incidente"]));

	$paciente["ahf"] = $d["antecedentes"]["ahf"];
	$paciente["app"] = $d["antecedentes"]["app"];
	$paciente["apnp"] = $d["antecedentes"]["apnp"];
	$paciente["alergias"] = $d["antecedentes"]["alergias"];
	$paciente["medicamentos"] = $d["antecedentes"]["medicamentos_cronicos"];
	$paciente["adicciones"] = $d["antecedentes"]["adicciones"];
	$paciente["otros_antecedentes"] = $d["antecedentes"]["otros_antecedentes"];

	$ml = $d["mecanismo_lesion"];
	foreach (["acc_auto","acc_motocicleta","acc_bicicleta","acc_peaton","acc_escolar","acc_otro"] as $k){
	  $paciente[$k] = array_values(array_filter(array_map('trim', explode(',', $ml[$k]))));
	}

	$ant_nombres = array_column($d["antecedentes_catalogados"], "nombre");
	$paciente["antecedentes_catalogados"] = implode(", ", $ant_nombres);

	$ef = $d["exploracion_fisica"];
	$paciente["exp_fisica"] = [
	  "temperatura" => $ef["temperatura"],
	  "talla" => $ef["talla"],
	  "peso" => $ef["peso"],
	  "ta" => $ef["ta"],
	  "fc" => $ef["fc"],
	  "fr" => $ef["fr"],
	  "pulso" => $ef["pulso"],
	  "rots" => $ef["rots"],
	  "glasgow" => $ef["glasgow"],
	  "edo_gral" => $ef["edo_gral"],
	  "mec_lesion_momento" => $ef["mec_lesion_momento"],
	  "mec_lesion_posterior" => $ef["mec_lesion_posterior"],
	  "descripcion" => $ef["descripcion_lesiones"]
	];

	$paciente["rx"] = [
	  "craneo"=>$d["estudios_imagen"]["rx_craneo"],
	  "c_cervical"=>$d["estudios_imagen"]["rx_cervical"],
	  "c_dorsal"=>$d["estudios_imagen"]["rx_dorsal"],
	  "c_lumbar"=>$d["estudios_imagen"]["rx_lumbar"],
	  "tora"=>$d["estudios_imagen"]["rx_torax"],
	  "oseo"=>$d["estudios_imagen"]["rx_oseo"],
	  "abdomen"=>$d["estudios_imagen"]["rx_abdomen"],
	  "hombro"=>$d["estudios_imagen"]["rx_hombro"],
	  "brazo"=>$d["estudios_imagen"]["rx_brazo"],
	  "antebrazo"=>$d["estudios_imagen"]["rx_antebrazo"],
	  "mano"=>$d["estudios_imagen"]["rx_mano"],
	  "muslo"=>$d["estudios_imagen"]["rx_muslo"],
	  "pierna"=>$d["estudios_imagen"]["rx_pierna"],
	  "tobillo_pie"=>$d["estudios_imagen"]["rx_tobillo_pie"],
	  "pelvis"=>$d["estudios_imagen"]["rx_pelvis"],
	  "rodilla"=>$d["estudios_imagen"]["rx_rodilla"],
	  "otros"=>$d["estudios_imagen"]["rx_otro"]
	];

	$paciente["imagen"] = [
	  "ultrasonido"=>$d["estudios_imagen"]["ultrasonido"],
	  "rmn"=>$d["estudios_imagen"]["rmn"],
	  "tac"=>$d["estudios_imagen"]["tac"],
	  "otros"=>$d["estudios_imagen"]["otros_imagen"],
	  "descripcion"=>$d["estudios_imagen"]["descripcion_imagen"]
	];

	$paciente["diagnostico"] = $d["diagnostico"]["diagnostico_principal"];
	$paciente["diagnostico_no_rel"] = $d["diagnostico"]["diagnostico_no_rel"];

	$meds = [];
	foreach ($d["prescripcion_medicamentos"] as $m) {
	  $meds[] = [
	    "medicamento" => $m["nombre"],
	    "cantidad" => $m["cantidad"],
	    "indicacion" => $m["indicacion"]
	  ];
	}

	$lm = "";
	foreach ($meds as $m) {
	  $lm .= '
	  <tr width="100%">
	    <td>
	      <table>
	        <tr>
	          <td width="2%"><span class="respuesta">'.$m["cantidad"].'</span></td>
	          <td width="50%"><span class="respuesta">'.$m["medicamento"].'</span></td>
	          <td width="48%"><span class="respuesta">'.$m["indicacion"].'</span></td>
	        </tr>
	      </table>
	    </td>
	  </tr>';
	}

	$proc = $d["interconsulta_procedimientos"];
	$paciente["interconsulta"] = [
	  "si_no"=>$proc["solicita_interconsulta"],
	  "especialidad"=>$proc["especialidad"],
	  "inmovilizacion"=>$proc["inmovilizacion"],
	  "co_blando"=>$proc["co_blando"],
	  "co_semirrigido"=>$proc["co_semirrigido"],
	  "co_philadelphia"=>$proc["co_philadelphia"],
	  "cabestrillo"=>$proc["cabestrillo"],
	  "faja"=>$proc["faja"],
	  "ferula"=>$proc["ferula"],
	  "otro"=>$proc["otro_inmovilizacion"],
	  "curaciones"=>$proc["curaciones"],
	  "suturas"=>$proc["suturas"],
	  "uso_por"=>$proc["uso_por"],
	  "retiro"=>$proc["retiro_fecha"],
	  "observaciones"=>$proc["observaciones"],
	  "pronostico"=>$proc["pronostico"]
	];

	$h = $d["hospitalizacion"];
	$paciente["hospitilazacion"] = [
	  "motivo"=>$h["motivo_hosp"],
	  "traslado"=>$h["traslado_hosp"],
	  "fecha_hora"=>$h["fecha_hora"],
	  "autoriza"=>$h["autoriza"],
	  "datos_ambulancia"=>$h["datos_ambulancia"]
	];

	return $paciente;
}


echo json_encode($datos);
mysqli_close($conexion);

?>